<?php
/**
* 2007-2020 PrestaShop
*
* NOTICE OF LICENSE
*
* This source file is subject to the Open Software License (OSL 3.0)
* that is bundled with this package in the file LICENSE.txt.
* It is also available through the world-wide-web at this URL:
* http://opensource.org/licenses/osl-3.0.php
* If you did not receive a copy of the license and are unable to
* obtain it through the world-wide-web, please send an email
* to license@buy-addons.com so we can send you a copy immediately.
*
* DISCLAIMER
*
* Do not edit or add to this file if you wish to upgrade PrestaShop to newer
* versions in the future. If you wish to customize PrestaShop for your
* needs please refer to http://www.prestashop.com for more information.
*
*  @author    Buy-Addons <contact@buy-addons.com>
*  @copyright 2007-2020 PrestaShop SA
*  @license   http://opensource.org/licenses/osl-3.0.php  Open Software License (OSL 3.0)
*  International Registered Trademark & Property of PrestaShop SA
* @since 1.6
*/

class BASmartSeoAltTags extends Module
{
    public $demo_mode = false;
    public $demo_buttons = array('savealt',
                                'savealtandstay',
                                'save',
                                'saveandregenerate',
                                'savepro',
                            );
    public static $s_name = false;
    public $license_pro = false;
    public function __construct()
    {
        $this->name = "basmartseoalttags";
        $this->tab = "seo";
        $this->version = "1.0.2";
        $this->author = "buy-addons";
        $this->need_instance = 0;
        $this->secure_key = Tools::encrypt($this->name);
        $this->bootstrap = true;
        $this->module_key = '23d0a831e28b69c95287f6a20b39223d';
        $this->displayName = $this->l('BA Smart Seo Product Images by ALT Tags');
        if (!$this->license_pro) {
             $this->displayName = $this->l('Buy-Addons.com - BA Smart Seo Product Images by ALT Tags');
        }
        $this->description = $this->l('Allows Improve SEO On-page of a PrestaShop website with ALT Tags of Images');
        self::$s_name = $this->name;
        $this->includeClasses();
        parent::__construct();
    }
    public function install()
    {
        if (parent::install() == false
            || !$this->registerhook('actionObjectUpdateAfter')
            || !$this->registerhook('actionObjectAddAfter')) {
            return false;
        }
        $this->installTab('AdminGenerateAltText', 'Admin Generate Alt Text');
        $this->setDefaultConfig();
        $this->includeClasses();
        $general = new BASmartSeoAltTagsGeneral();
        $general->installNew();
        
        $general = new BASmartSeoAltTagsProsetting();
        $general->installNew();
        return true;
    }
    public function uninstall()
    {
        if (parent::uninstall() == false) {
            return false;
        }
        $this->includeClasses();
        BASmartSeoAltTagsGeneral::uninstallNew();
        
        $general = new BASmartSeoAltTagsProsetting();
        $general->uninstallNew();
        return true;
    }
    public function includeClasses()
    {
        require_once(_PS_MODULE_DIR_.$this->name.'/includes/class.general.php');
        require_once(_PS_MODULE_DIR_.$this->name.'/includes/class.prosetting.php');
        require_once(_PS_MODULE_DIR_.$this->name.'/includes/class.altsmanage.php');
    }
    public function setDefaultConfig()
    {
    }
    public function shortDisplay($file)
    {
        return $this->display(__FILE__, $file);
    }
    public function hookactionObjectUpdateAfter($params)
    {
        $object = $params['object'];
        $general = new BASmartSeoAltTagsGeneral();
        if ($this->license_pro) {
            $auto_edit = (int) Configuration::get($this->name.'_auto_edit');
            if ($auto_edit == 1) {
                return $general->updateObject($object);
            }
        } else {
            return $general->updateObject($object);
        }
    }
    public function hookactionObjectAddAfter($params)
    {
        $object = $params['object'];
        $general = new BASmartSeoAltTagsGeneral();
        if ($this->license_pro) {
            $auto_add = (int) Configuration::get($this->name.'_auto_add');
            if ($auto_add == 1) {
                return $general->updateObject($object);
            }
        } else {
            return $general->updateObject($object);
        }
    }
    /******** end core **************/
    public function getContent()
    {
        $this->context->controller->addCSS($this->_path . 'views/css/backend.css');
        // automatic generate keywords for all products, categories... after install module
        $regenerateALL = Configuration::getGlobalValue($this->name.'_regenerateALL');
        if ($regenerateALL == 1) {
            $this->context->controller->addJS($this->_path . 'views/js/regenerate_all.js');
        }
        $this->context->controller->addJS($this->_path . 'views/js/backend.js');
        $batask = Tools::getValue("batask", "general");
        $demo_mode = Tools::getValue("demo_mode", 0);
        $m_class =  get_class($this).$batask;
        if (!class_exists($m_class)) {
            $batask =  "general";
            $m_class =  get_class($this).$batask;
        }
        $link_module = AdminController::$currentIndex;
        $link_module .= '&token='.Tools::getAdminTokenLite('AdminModules');
        $link_module .= '&configure='.$this->name;
        $this->context->smarty->assign('batask', $batask);
        $this->context->smarty->assign('demo_mode', $demo_mode);
        $this->context->smarty->assign('license_pro', $this->license_pro);
        $this->context->smarty->assign('link_module', $link_module);
        $this->context->smarty->assign('ajax_token', $this->getAjaxToken());
        if ($this->demo_mode) {
            foreach ($this->demo_buttons as $button) {
                if (Tools::isSubmit($button)) {
                    Tools::redirectAdmin($link_module.'&demo_mode=1');
                    return true;
                }
            }
        }
        $starter = new $m_class();
        return $starter->process();
    }
    public function installTab($className, $tabName)
    {
        $tab = new Tab();
        $tab->active = 1;
        $tab->class_name = $className;
        $tab->name = array();
        $tab->position = 7;
        foreach (Language::getLanguages(true) as $lang) {
            $tab->name[$lang['id_lang']] = $tabName;
        }
        $tab->id_parent = -1;
        $tab->module = $this->name;
        $tab->add();
        $tab->save();
        return true;
    }
    public function uninstallTab($className)
    {
        $tab = new Tab((int) Tab::getIdFromClassName($className));
        $tab->delete();
        return true;
    }
    public function getAjaxToken()
    {
        $ajax_token = sha1(_COOKIE_KEY_ . $this->name);
        $ajax_token = md5($ajax_token);
        return $ajax_token;
    }
}
