/**
 * 2007-2020 PrestaShop
 *
 * NOTICE OF LICENSE
 *
 * This source file is subject to the Academic Free License (AFL 3.0)
 * that is bundled with this package in the file LICENSE.txt.
 * It is also available through the world-wide-web at this URL:
 * http://opensource.org/licenses/afl-3.0.php
 * If you did not receive a copy of the license and are unable to
 * obtain it through the world-wide-web, please send an email
 * to license@buy-addons.com so we can send you a copy immediately.
 *
 * DISCLAIMER
 *
 * Do not edit or add to this file if you wish to upgrade PrestaShop to newer
 * versions in the future. If you wish to customize PrestaShop for your
 * needs please refer to http://www.prestashop.com for more information.
 *
 *  @author    PrestaShop SA <contact@buy-addons.com>
 *  @copyright 2007-2020 PrestaShop SA
 *  @license   http://opensource.org/licenses/afl-3.0.php  Academic Free License (AFL 3.0)
 *  International Registered Trademark & Property of PrestaShop SA
 */
"use strict";
$(document).ready(function(){
	// start to build Alt Text
	basmartseoalttags_buildAltText();
});
function basmartseoalttags_buildAltText(){
	var bg = $(".basmartseoalttags_response_overlay");
	if (!bg.is(":visible")) {
		var html = '<div class="basmartseoalttags_response_overlay">';
		html += '<img src="../modules/basmartseoalttags/views/img/loading.gif" />';
		html += '</div>';
		$("#basmartseoalttags_response_msg").after(html);
	}
	var time = Date.now();
	var url = 'index.php?controller=AdminGenerateAltText';
	url += '&ajax_token='+basmartseoalttags_ajax_token + '&time=' + time;
	$.ajax({
		url : url, 
		type : "POST",
		crossDomain  : true,
		datatype:'json',
		success : function (response){
			var response = $.parseJSON(response);
			var i =0;
			for (i=0; i<response.msg.length; i++) {
				basmartseoalttags_showMsg(response.msg[i]);
			}
			if (response.finished == 0) {
				setTimeout(basmartseoalttags_buildAltText, 500);
			} else {
				setTimeout(function(){
					$("#basmartseoalttags_response_msg").html('');
					bg.remove();
				}, 500);
			}
		}
	});
}
function basmartseoalttags_showMsg(msg){
	var html = '<div class="alert alert-success">';
	html += '<button type="button" class="close" data-dismiss="alert">×</button>'+msg+'</div>';
	$("#basmartseoalttags_response_msg").prepend(html);
}