{*
* 2007-2020 PrestaShop
*
* NOTICE OF LICENSE
*
* This source file is subject to the Academic Free License (AFL 3.0)
* that is bundled with this package in the file LICENSE.txt.
* It is also available through the world-wide-web at this URL:
* http://opensource.org/licenses/afl-3.0.php
* If you did not receive a copy of the license and are unable to
* obtain it through the world-wide-web, please send an email
* to license@buy-addons.com so we can send you a copy immediately.
*
* DISCLAIMER
*
* Do not edit or add to this file if you wish to upgrade PrestaShop to newer
* versions in the future. If you wish to customize PrestaShop for your
* needs please refer to http://www.prestashop.com for more information.
*
* @author    Buy-addons    <contact@buy-addons.com>
* @copyright 2007-2020 Buy-addons
* @license   http://opensource.org/licenses/afl-3.0.php  Academic Free License (AFL 3.0)
*  International Registered Trademark & Property of PrestaShop SA
*}
{include file="./tab.tpl"}
<div class="panel bageneral-box">
    <h3><i class="icon-cogs"></i> {l s='Edit Alt Text' mod='basmartseoalttags'}</h3>
	<form enctype="multipart/form-data" method="post" class="form-horizontal">
		<input type="hidden" name="batask" value="altsmanage" />
		<input type="hidden" name="id_image" value="{$id_image|escape:'htmlall':'UTF-8'}" />
		<input type="hidden" name="id_lang" value="{$id_lang|escape:'htmlall':'UTF-8'}" />
		<input type="hidden" name="key_image" value="{$key_image|escape:'htmlall':'UTF-8'}" />
		<div class="form-group">
			<label class="control-label col-lg-3">
				<span class="label-tooltip">{l s='Language' mod='basmartseoalttags'}</span>
			</label>
			<div class="col-lg-5 plain_text">
				{$current_lang|escape:'htmlall':'UTF-8'}
			</div>
		</div>
		<div class="form-group">
			<label class="control-label col-lg-3">
				<span class="label-tooltip">{l s='Product' mod='basmartseoalttags'}</span>
			</label>
			<div class="col-lg-5 plain_text">
				<a href="{$p_link|escape:'htmlall':'UTF-8'}" target="_blank">{$product_name|escape:'htmlall':'UTF-8'} (<span>{l s='id' mod='basmartseoalttags'}</span>: {$id_product|escape:'htmlall':'UTF-8'})</a>
			</div>
		</div>
		<div class="form-group">
			<label class="control-label col-lg-3">
				<span class="label-tooltip">{l s='Image ID' mod='basmartseoalttags'}</span>
			</label>
			<div class="col-lg-5 plain_text">
				<a href="{$p_link|escape:'htmlall':'UTF-8'}" target="_blank">#{$id_image|escape:'htmlall':'UTF-8'}</a>
			</div>
		</div>
		<div class="form-group">
			<label class="control-label col-lg-3">
				<span class="label-tooltip">{l s='Alt Text (Caption)' mod='basmartseoalttags'}</span>
			</label>
			<div class="col-lg-5">
				<input type="text" id="legend" name="legend" value="{$item.$id_lang|escape:'htmlall':'UTF-8'}" />
			</div>
		</div>
		<div class="form-group">
			<label class="control-label col-lg-3">
				{l s='Update this Alt Text for other languages of this Image' mod='basmartseoalttags'}
			</label>
			<div class="col-lg-5">
				<span class="switch prestashop-switch fixed-width-lg">
					<input onclick="toggleDraftWarning(false);showOptions(true);showRedirectProductOptions(false);" type="radio" name="otherlanguage" id="otherlanguage_on" value="1" />
					<label for="otherlanguage_on" class="radioCheck">
						{l s='Yes' mod='basmartseoalttags'}
					</label>
					<input onclick="toggleDraftWarning(true);showOptions(false);showRedirectProductOptions(true);" type="radio" name="otherlanguage" id="otherlanguage_off" value="0" checked/>
					<label for="otherlanguage_off" class="radioCheck">
						{l s='No' mod='basmartseoalttags'}
					</label>
					<a class="slide-button btn"></a>
				</span>
			</div>
		</div>
		<div class="form-group">
			<label class="control-label col-lg-3">
				<span class="label-tooltip">{l s='Alt text of other languages of this Image' mod='basmartseoalttags'}</span>
			</label>
			<div class="col-lg-5 plain_text">
				{if count($others) > 0}
					{foreach from=$others item=item}
						{$item|escape:'htmlall':'UTF-8'} <br />
					{/foreach}
				{/if}
			</div>
		</div>
		<div class="panel-footer">
			<a href="{$link_module|escape:'htmlall':'UTF-8'}&batask=altsmanage" class="btn btn-default"><i class="process-icon-cancel"></i> {l s='Cancel' mod='basmartseoalttags'}</a>
			<button type="submit" name="savealt" class="btn btn-default pull-right"><i class="process-icon-save"></i> {l s='Save' mod='basmartseoalttags'}</button>
			<button type="submit" name="savealtandstay" class="btn btn-default pull-right"><i class="process-icon-save"></i> {l s='Save and stay' mod='basmartseoalttags'}</button>
		</div>
	</form>
</div>