{*
* 2007-2020 PrestaShop
*
* NOTICE OF LICENSE
*
* This source file is subject to the Academic Free License (AFL 3.0)
* that is bundled with this package in the file LICENSE.txt.
* It is also available through the world-wide-web at this URL:
* http://opensource.org/licenses/afl-3.0.php
* If you did not receive a copy of the license and are unable to
* obtain it through the world-wide-web, please send an email
* to license@buy-addons.com so we can send you a copy immediately.
*
* DISCLAIMER
*
* Do not edit or add to this file if you wish to upgrade PrestaShop to newer
* versions in the future. If you wish to customize PrestaShop for your
* needs please refer to http://www.prestashop.com for more information.
*
* @author    Buy-addons    <contact@buy-addons.com>
* @copyright 2007-2020 Buy-addons
* @license   http://opensource.org/licenses/afl-3.0.php  Academic Free License (AFL 3.0)
*  International Registered Trademark & Property of PrestaShop SA
*}
<style>
#content.bootstrap .panel.bageneral-box{
	border-top-left-radius:0;
}
</style>
{include file="./tab.tpl"}
<form enctype="multipart/form-data" method="post" class="form-horizontal">
<div class="panel bageneral-box bageneral-filter-product">
    <h3 class="panel-heading" rev="#filter-product-wrapper">
	<i class="icon-cogs"></i> {l s='Filter Products' mod='basmartseoalttags'}
	<span class="button-collapse"><i class="icon-collapse-alt"></i></span>
	</h3>
	<input type="hidden" name="batask" value="general" />
	<div id="filter-product-wrapper">
		<div class='form-group'>
			<label class="control-label col-lg-3">
			{l s='Manufacturers' mod='basmartseoalttags'}
			</label>
			<div class='col-lg-5'>
				<table class='table table-bordered'>
					<tbody>
						<tr>
							<td>
								<span class="title_box">
									<input type="checkbox" onclick="$(this).parents('.form-group').find('.checkbox_table').prop('checked', this.checked)">
								</span>
							</td>
							<td>
								<span class="title_box">
									{l s='Name' mod='basmartseoalttags'}  
								</span>
							</td>
						</tr>
						<tr>
							<td>
								<input type="checkbox" name="manufacturers[]" value="0" class="checkbox_table"{if !empty($selected_manufacturers) && in_array(0,$selected_manufacturers)} checked{/if}/>
							</td>
							<td>
								<label> - </label>
							</td>
						</tr>
						{foreach from=$manufacturers item=manufacturer}
							<tr>
								<td>
									<input type="checkbox" name="manufacturers[]" value="{$manufacturer.id_manufacturer|escape:'htmlall':'UTF-8'}" class="checkbox_table"{if !empty($selected_manufacturers) && in_array($manufacturer.id_manufacturer,$selected_manufacturers)} checked{/if}/>
								</td>
								<td>
									<label>{$manufacturer.name|escape:'htmlall'}</label>
								</td>
							</tr>
						{/foreach}
					</tbody>
				</table>
			</div>
        </div>
		<div class='form-group'>
			<label class="control-label col-lg-3">
			{l s='Suppliers' mod='basmartseoalttags'}
			</label>
			<div class='col-lg-5'>
				<table class='table table-bordered'>
					<tbody>
						<tr>
							<td>
								<span class="title_box">
									<input type="checkbox" onclick="$(this).parents('.form-group').find('.checkbox_table').prop('checked', this.checked)">
								</span>
							</td>
							<td>
								<span class="title_box">
									{l s='Name' mod='basmartseoalttags'}  
								</span>
							</td>
						</tr>
						{foreach from=$suppliers item=supplier}
							<tr>
								<td>
									<input type="checkbox" name="suppliers[]" value="{$supplier.id_supplier|escape:'htmlall':'UTF-8'}" class="checkbox_table"{if !empty($selected_suppliers) && in_array($supplier.id_supplier,$selected_suppliers)} checked{/if}/>
								</td>
								<td>
									<label>{$supplier.name|escape:'htmlall'}</label>
								</td>
							</tr>
						{/foreach}
					</tbody>
				</table>
			</div>
        </div>
		<div class='form-group'>
			<label class="col-lg-3 control-label" style="margin-top:10px;">
			{l s='Category' mod='basmartseoalttags'}
			</label>
			<div class="col-lg-5">
				{$categories nofilter}{*Escape is unnecessary*}
			</div>
		</div>
		<div class="form-group">
			<label class="col-lg-3 control-label">
			{l s='Status' mod='basmartseoalttags'}
			</label>
			<div class="col-lg-2">
				<select name="status">
					<option value="0"{if $status == 0} selected{/if}>{l s='All' mod='basmartseoalttags'}</option>
					<option value="1"{if $status == 1} selected{/if}>{l s='Enabled' mod='basmartseoalttags'}</option>
					<option value="2"{if $status == 2} selected{/if}>{l s='Disabled' mod='basmartseoalttags'}</option>
				</select>
			</div>
        </div>
		<div class="form-group">
			<label class="control-label col-lg-3">
				{l s='Visibility' mod='basmartseoalttags'}
			</label>
			<div class="col-lg-3">
				<select name="visibility[]" id="visibility" size="4" multiple>
					<option value="both"{if !empty($visibility) && in_array('both',$visibility)} selected{/if}>{l s='Everywhere' mod='basmartseoalttags'}</option>
					<option value="catalog"{if !empty($visibility) && in_array('catalog',$visibility)} selected{/if}>{l s='Catalog only' mod='basmartseoalttags'}</option>
					<option value="search"{if !empty($visibility) && in_array('search',$visibility)} selected{/if}>{l s='Search only' mod='basmartseoalttags'}</option>
					<option value="none"{if !empty($visibility) && in_array('none',$visibility)} selected{/if}>{l s='Nowhere' mod='basmartseoalttags'}</option>
				</select>
			</div>
		</div>
		<div class="form-group">
			<label class="control-label col-lg-3">{l s='Price' mod='basmartseoalttags'}</label>
			<div class="form-group col-lg-6">
				<div class="col-lg-2">
					<div class="input-group">
						<span class="input-group-addon">{$currency->sign|escape:'htmlall':'UTF-8'}</span>
						<input name="price[from]" type="text" placeholder="{l s='From' mod='basmartseoalttags'}" onkeypress="return event.charCode >= 48 && event.charCode <= 57" onpaste="return false;" value="{$price->from|escape:'htmlall':'UTF-8'}" />
					</div>
				</div>
				<div class="separator-minus"> {l s='-' mod='basmartseoalttags'} </div>
				<div class="col-lg-2">
					<div class="input-group">
						<span class="input-group-addon">{$currency->sign|escape:'htmlall':'UTF-8'}</span>
						<input name="price[to]" type="text" placeholder="{l s='To' mod='basmartseoalttags'}" onkeypress="return event.charCode >= 48 && event.charCode <= 57" onpaste="return false;" value="{$price->to|escape:'htmlall':'UTF-8'}" />
					</div>
				</div>
			</div>
		</div>
		<div class="form-group">
			<label class="control-label col-lg-3">{l s='Quantity' mod='basmartseoalttags'}</label>
			<div class="form-group col-lg-6">
				<div class="col-lg-3">
					<div class="input-group">
						<span class="input-group-addon">{l s='From' mod='basmartseoalttags'}</span>
						<input name="quantity[from]" type="text" placeholder="{l s='From' mod='basmartseoalttags'}" onkeypress="return event.charCode >= 48 && event.charCode <= 57" onpaste="return false;" value="{$quantity->from|escape:'htmlall':'UTF-8'}"/>
					</div>
				</div>
				<div class="separator-minus"> {l s='-' mod='basmartseoalttags'} </div>
				<div class="col-lg-3">
					<div class="input-group">
						<span class="input-group-addon">{l s='To' mod='basmartseoalttags'}</span>
						<input name="quantity[to]" type="text" placeholder="{l s='To' mod='basmartseoalttags'}" onkeypress="return event.charCode >= 48 && event.charCode <= 57" onpaste="return false;" value="{$quantity->to|escape:'htmlall':'UTF-8'}"/>
					</div>
				</div>
			</div>
		</div>
		<div class="form-group">
			<div class="control-label col-lg-3">
					{l s='Created Date' mod='basmartseoalttags'}
			</div>
			<div class="col-lg-2">
				<div class="input-group">
					<input name="created_date[from]" placeholder="{l s='From' mod='basmartseoalttags'}"  onkeypress="return event.charCode >= 48 && event.charCode <= 57" onpaste="return false;" class="date" type="text" value="{$created_date->from|escape:'htmlall':'UTF-8'}"/>
					<span class="input-group-addon">
						<i class="icon-calendar"></i>
					</span>
				</div>
			</div>
			<div class="separator-minus"> {l s='-' mod='basmartseoalttags'} </div>
			<div class="col-lg-2">
				<div class="input-group">
					<input name="created_date[to]" placeholder="{l s='To' mod='basmartseoalttags'}"  onkeypress="return event.charCode >= 48 && event.charCode <= 57" onpaste="return false;" class="date" type="text" value="{$created_date->to|escape:'htmlall':'UTF-8'}"/>
					<span class="input-group-addon">
						<i class="icon-calendar"></i>
					</span>
				</div>
			</div>
		</div>
		<div class="form-group">
			<div class="control-label col-lg-3">
					{l s='Updated Date' mod='basmartseoalttags'}
			</div>
			<div class="col-lg-2">
				<div class="input-group">
					<input name="updated_date[from]" placeholder="{l s='From' mod='basmartseoalttags'}"  onkeypress="return event.charCode >= 48 && event.charCode <= 57" onpaste="return false;" class="date" type="text" value="{$updated_date->from|escape:'htmlall':'UTF-8'}"/>
					<span class="input-group-addon">
						<i class="icon-calendar"></i>
					</span>
				</div>
			</div>
			<div class="separator-minus"> {l s='-' mod='basmartseoalttags'} </div>
			<div class="col-lg-2">
				<div class="input-group">
					<input name="updated_date[to]" placeholder="{l s='To' mod='basmartseoalttags'}"  onkeypress="return event.charCode >= 48 && event.charCode <= 57" onpaste="return false;" class="date" type="text" value="{$updated_date->to|escape:'htmlall':'UTF-8'}"/>
					<span class="input-group-addon">
						<i class="icon-calendar"></i>
					</span>
				</div>
			</div>
		</div>
	</div>
</div>
{include file="./general_alt.tpl"}
</form>