# Customer reassurance block

[![Build Status](https://travis-ci.com/PrestaShop/blockreassurance.svg?branch=master)](https://travis-ci.com/PrestaShop/blockreassurance)
[![Latest Stable Version](https://poser.pugx.org/PrestaShop/blockreassurance/v)](//packagist.org/packages/PrestaShop/blockreassurance)
[![Total Downloads](https://poser.pugx.org/PrestaShop/blockreassurance/downloads)](//packagist.org/packages/PrestaShop/blockreassurance)
[![GitHub license](https://img.shields.io/github/license/PrestaShop/blockreassurance)](https://github.com/PrestaShop/blockreassurance/LICENSE.md)


## About

Adds an information block aimed at offering helpful information to reassure customers that your store is trustworthy.

## Multistore compatibility

This module is compatible with the multistore :heavy_check_mark: <br/>
It can be configured differently from one store to another.<br/>
It can be configured quickly in the same way on all stores thanks to the all shops context or the group of shops.<br/>
It can be activated on one store and deactivated on another

## Reporting issues

You can report issues with this module in the main PrestaShop repository. [Click here to report an issue][report-issue]. 

## Requirements

Required only for development:

- npm
- composer

## Installation

Install all dependencies.
```
npm install
composer install
```

## Usage

```
npm run dev # Watch js/css files for changes
npm run build # Build for production
```

## Contributing

PrestaShop modules are open source extensions to the [PrestaShop e-commerce platform][prestashop]. Everyone is welcome and even encouraged to contribute with their own improvements!

Just make sure to follow our [contribution guidelines][contribution-guidelines].

## License

This module is released under the [Academic Free License 3.0][AFL-3.0] 

[report-issue]: https://github.com/PrestaShop/PrestaShop/issues/new/choose
[prestashop]: https://www.prestashop.com/
[contribution-guidelines]: https://devdocs.prestashop.com/1.7/contribute/contribution-guidelines/project-modules/
[AFL-3.0]: https://opensource.org/licenses/AFL-3.0
