<?php
/**
 * Google Merchant Center
 *
 * @author    BusinessTech.fr - https://www.businesstech.fr
 * @copyright Business Tech 2019 - https://www.businesstech.fr
 * @license   Commercial
 *
 *           ____    _______
 *          |  _ \  |__   __|
 *          | |_) |    | |
 *          |  _ <     | |
 *          | |_) |    | |
 *          |____/     |_|
 */

class BT_GmcHookAction extends BT_GmcHookBase
{
    /**
     * execute hook
     *
     * @param array $aParams
     * @return array
     */
    public function run(array $aParams = null)
    {
        // set variables
        $aDisplayHook = array();

        switch ($this->sHook) {
            case 'searchProduct' :
                // use case - display nothing only process storage in order to send an email
                $aDisplayHook = call_user_func_array(array($this, 'searchProduct'), array($aParams));
                break;
            default :
                break;
        }

        return $aDisplayHook;
    }

    /**
     * search product with the autocomplete feature
     *
     * @param array $aParams
     * @return array
     */
    private function searchProduct(array $aParams = null)
    {
        return array('tpl' => _GMC_TPL_HOOK_PATH . _GMC_TPL_ORDER_CONFIRMATION, 'assign' => array());
    }
}
