<?php
/**
* 2007-2017 PrestaShop
*
* NOTICE OF LICENSE
*
* This source file is subject to the Academic Free License (AFL 3.0)
* that is bundled with this package in the file LICENSE.txt.
* It is also available through the world-wide-web at this URL:
* http://opensource.org/licenses/afl-3.0.php
* If you did not receive a copy of the license and are unable to
* obtain it through the world-wide-web, please send an email
* to license@prestashop.com so we can send you a copy immediately.
*
* DISCLAIMER
*
* Do not edit or add to this file if you wish to upgrade PrestaShop to newer
* versions in the future. If you wish to customize PrestaShop for your
* needs please refer to http://www.prestashop.com for more information.
*
*  @author    LD
*  @copyright 2018 LD
*  @version   1.0.0
*  @link      http://www.ld.com.br/
*  @license
*
*  Based on the following version
* 
*  @author    DJTAL
*  @copyright 2017 DJTAL
*  @version   1.0.0
*  @link      http://www.djtal.com.br/
*/

class Address extends AddressCore {

    public $numend;

    public function setWsNumAddressData() {
        $addressArray = explode(',', $this->address1);
        if(count($addressArray) == 3) {
            if(is_numeric(trim($addressArray[1]))){
                return trim($addressArray[1]);
            } elseif(is_numeric(trim($addressArray[2]))){
                return trim($addressArray[2]);
            } else {
                return trim($addressArray[1]);
            }
        } elseif(count($addressArray) == 2) {
            return trim($addressArray[1]);
        }
        return null;
    }

    public function __construct($id = null) {
        parent::__construct($id);

        $this->webserviceParameters['fields']['numend'] = array();
        $this->numend = $this->setWsNumAddressData();
    }
}
