<?php
/**
* 2007-2017 PrestaShop
*
* NOTICE OF LICENSE
*
* This source file is subject to the Academic Free License (AFL 3.0)
* that is bundled with this package in the file LICENSE.txt.
* It is also available through the world-wide-web at this URL:
* http://opensource.org/licenses/afl-3.0.php
* If you did not receive a copy of the license and are unable to
* obtain it through the world-wide-web, please send an email
* to license@prestashop.com so we can send you a copy immediately.
*
* DISCLAIMER
*
* Do not edit or add to this file if you wish to upgrade PrestaShop to newer
* versions in the future. If you wish to customize PrestaShop for your
* needs please refer to http://www.prestashop.com for more information.
*
*  @author    LD
*  @copyright 2018 LD
*  @version   1.0.0
*  @link      http://www.ld.com.br/
*  @license
*
*  Based on the following version
* 
*  @author    DJTAL
*  @copyright 2017 DJTAL
*  @version   1.0.0
*  @link      http://www.djtal.com.br/
*/

class Customer extends CustomerCore {

    public $cpf;
    public $cnpj;
    public $rg;
    public $ie;
	
	public $cpf_or_cnpj;
    public $pf_or_pj;

    public function setWsBrazilianData() {
        include_once _PS_MODULE_DIR_ . 'ldbrazilianregister/models/BrazilianRegister.class.php';
        $breg = BrazilianRegister::getByCustomerId($this->id);
        $this->cpf = $breg['cpf'];
        $this->cnpj = $breg['cnpj'];
        $this->rg = $breg['rg'];
        $this->ie = $breg['ie'];
		
		if(!empty($breg['cnpj'])){
			$this->cpf_or_cnpj = $breg['cnpj'];
			$this->pf_or_pj = 'pj';
		}elseif(!empty($breg['cpf'])){
			$this->cpf_or_cnpj = $breg['cpf'];
			$this->pf_or_pj = 'pf';
		}
    }

    public function __construct($id = null) {

        parent::__construct($id);

        $this->webserviceParameters['fields']['cpf'] = array();
        $this->webserviceParameters['fields']['cnpj'] = array();
        $this->webserviceParameters['fields']['rg'] = array();
        $this->webserviceParameters['fields']['ie'] = array();
		
		$this->webserviceParameters['fields']['cpf_or_cnpj'] = array();
        $this->webserviceParameters['fields']['pf_or_pj'] = array();

        $this->setWsBrazilianData();
    }
}
