<?php

if (!defined('_PS_VERSION_')) exit;

include_once(dirname(__FILE__).'/models/LDCorreiosServe.php');
 
class LDCorreiosCampos extends Module 
{
    public function form_geral() 
    {

        $servicos[] = array(
            'id' => 'mao_propria',
            'name' => 'Mão Própria',
            'val' => 'on',
        );

         $servicos[] = array(
            'id' => 'valor_declarado',
            'name' => 'Valor Declarado',
            'val' => 'on',
        );

          $servicos[] = array(
            'id' => 'aviso_recebimento',
            'name' => 'Aviso de Recebimento',
            'val' => 'on',
        );

        $fields_form = array(
            $this->text ('ldcorreios_serial', 'Código de Licença','',false,false,'Informe seu código de licença/número serial.', ''),
           $this->separador('Parâmetros de Operação'),
           $this->field_onOff('ldcorreios_bloco_carrinho','Exibir simulador no carrinho de compras?', 'Marque SIM para que seja exibido um simulador de cálculo de frete na página do carrinho de compras.'),
           $this->field_onOff('ldcorreios_bloco_produto','Exibir simulador a página do produto?','Marque SIM para que seja exibido um simulador de cálculo de frete na página do carrinho de cada produto.'),
            $this->text('ldcorreios_meu_cep', 'CEP de Origem', 'input-large', false, 'Informe o CEP de onde você postará os seus pacotes', true),
            $this->textarea ('ldcorreios_cep_cidade', 'Faixa de CEP Local','',false,false,'Informe as faixas de CEP da sua cidade.', true),
            $this->text ('ldcorreios_tempo_preparacao', 'Prazo Adicional', 'input-large', false, 'Informe uma quantidade de dias para sempre ser adicionada ao prazo de entrega.', true),
            $this->separador('Serviços Adicionais'),
            $this->paragrafo('Ao ativar um serviço adicional, poderão haver cobranças extras. Por favor, consulte a tabela de tarifas dos Correios.'),
            $this->checkbox('ldcorreios', 'Selecionar Serviços', $servicos),
            $this->separador('Funcionamento do módulo'),
            $this->text('ldcorreios_taxaconversao','Taxa de conversão do PESO','',false,'O padrão é 1 para KG, caso use gramas por exemplo, coloque: 0,001',true,''),
            $this->field_onOff('ldcorreios_offline','Utilizar somente Tabela Offline', 'Antes de ativar esta opção, você precisa, gerar toda  tabela off-line. Após isto você pode ativar esta opção.'),
            
        );
        return $this->getFormSection($fields_form, 'Configurações Gerais');
    }

    public function get_campos_geral()
    {
        return array(
            'ldcorreios_bloco_carrinho',
            'ldcorreios_bloco_produto',
            'ldcorreios_meu_cep',
            'ldcorreios_cep_cidade',
            'ldcorreios_tempo_preparacao',
            'ldcorreios_servicos',
            'ldcorreios_mao_propria',
            'ldcorreios_aviso_recebimento',
            'ldcorreios_valor_declarado',
            'ldcorreios_taxaconversao',
            'ldcorreios_offline',
            'ldcorreios_debug',
            );
    }


    public function form_pac() 
    {

        $id_servico = $this->get_id_servico('PAC');

        $fields_form = array(
           $this->separador('Configurações do serviço de PAC'),
           $this->field_onOff('ldcorreios_servicos_ativo_'.$id_servico,'Ativar', 'Marque SIM para exibir esta modalidade no seu site.'),

            $this->textarea('ldcorreios_servico_desativar_faixas_'.$id_servico, 'Faixas de CEP Excluídas','',false,false,'Informe as faixas de CEP para as quais este serviço não será oferecido.', false),

            $this->separador('Dados do Contrato (opcional)'),

            $this->text ('ldcorreios_espec_codigos_'.$id_servico, 'Código de Serviço', 'input-large', false, '', true),
            $this->text ('ldcorreios_espec_codigoa_'.$id_servico, 'Código Administrativo', 'input-large', false, '', false),
            $this->text ('ldcorreios_espec_senha_'.$id_servico, 'Senha', 'input-large', false, '', false),

            $this->separador('Opções avançadas (opcional)'),

            $this->paragrafo('DIMENSÕES E PESOS'),
            $this->text ('ldcorreios_espec_compmin_'.$id_servico, 'Comprimento Mínimo', 'input-large', false, ''),
            $this->text ('ldcorreios_espec_compmax_'.$id_servico, 'Comprimento Máximo', 'input-large', false, ''),
            $this->text ('ldcorreios_espec_larguramin_'.$id_servico, 'Largura Mínima', 'input-large', false, ''),
            $this->text ('ldcorreios_espec_larguramax_'.$id_servico, 'Largura Máxima', 'input-large', false, ''),
            $this->text ('ldcorreios_espec_alturamin_'.$id_servico, 'Altura Mínima', 'input-large', false, ''),
            $this->text ('ldcorreios_espec_alturamax_'.$id_servico, 'Altura Máxima', 'input-large', false, ''),
            $this->text ('ldcorreios_espec_dimensoesmax_'.$id_servico, 'Perímetro Máximo', 'input-large', false, ''),
            $this->text ('ldcorreios_espec_pesoemax_'.$id_servico, 'Peso Máximo - Estadual', 'input-large', false, ''),
            $this->text ('ldcorreios_espec_pesonmax_'.$id_servico, 'Peso Máximo - Nacional', 'input-large', false, ''),
            $this->textarea('ldcorreios_espec_intervaloe_'.$id_servico, 'Intervalos de Pesos - Estadual','',false,false,'', false),
            $this->textarea('ldcorreios_espec_intervalon_'.$id_servico, 'Intervalos de Pesos - Nacional','',false,false,'', false),
            $this->paragrafo('VALORES PARA CÁLCULO OFFLINE'),
            $this->text ('ldcorreios_espec_cubagemi_'.$id_servico, 'Cubagem Máxima Isenta', 'input-large', false, ''),
            $this->text ('ldcorreios_espec_cubagemb_'.$id_servico, 'Cubagem para base do cálculo', 'input-large', false, ''),
            $this->text ('ldcorreios_espec_maopropria_'.$id_servico, 'Tarifa Mão Própria', 'input-large', false, ''),
            $this->text ('ldcorreios_espec_aviso_'.$id_servico, 'Tarifa Aviso de Recebimento', 'input-large', false, ''),
            $this->text ('ldcorreios_espec_valord_'.$id_servico, 'Valor Declarado (%)', 'input-large', false, ''),
            $this->text ('ldcorreios_espec_valordmax_'.$id_servico, 'Máximo valor declarado', 'input-large', false, ''),
            $this->text ('ldcorreios_espec_seguro_'.$id_servico, 'Seguro Automático', 'input-large', false, ''),

        );
        return $this->getFormSection($fields_form, 'PAC');

    }

    public function form_offline()
    {
        $sql = 'select ld_correios_especificacoes.id, servico from ld_correios_especificacoes, ld_correios_servicos
where ld_correios_servicos.id_especificacao = ld_correios_especificacoes.id AND
ld_correios_servicos.ativo = 1';
    
        
        $servicosAtivos = Db::getInstance()->ExecuteS($sql);
        $campos = '';
        $campos2 = '';
        
        foreach($servicosAtivos as $as)
        {
            $primeiro = '';
            $sqlid ='SELECT id, prazo_entrega_cidade, prazo_entrega_capital, prazo_entrega_interior, tabela_cidade, tabela_capital, tabela_interior  FROM ld_correios_tabelas_offline WHERE id_especificacao = ' . $as['id'] .' order by id';
            $sqlid = Db::getInstance()->ExecuteS($sqlid);
            foreach($sqlid as $registro)
            {
                $comecaid = $registro['id'];
                if ($primeiro == '')
                {
                    $primeiro = $comecaid;
                }
                $campoCapital = '';
                $campoCidade = '';
                $campoInterior = '';
                if ($registro['tabela_capital'] == '')
                {
                    $campoCapital = '<span style="color:red; background-color:yellow;" id="capital' . $comecaid . '">Prazo: ' . $registro['prazo_entrega_capital'] . ' Preços: ' . $registro['tabela_capital'] .'</span>';
                } else {
                    $campoCapital = '<span  id="capital' . $comecaid . '">Prazo: ' . $registro['prazo_entrega_capital'] . ' Preços: ' . $registro['tabela_capital'] .'</span>';
                }
                if ($registro['tabela_cidade'] == '')
                {
                    $campoCidade = '<span style="color:red; background-color:yellow;" id="cidade' . $comecaid . '">Prazo: ' . $registro['prazo_entrega_cidade'] . ' Preços: ' . $registro['tabela_cidade'] .'</span>';
                } else {
                    $campoCidade = '<span  id="cidade' . $comecaid . '">Prazo: ' . $registro['prazo_entrega_cidade'] . ' Preços: ' . $registro['tabela_cidade'] .'</span>';
                }
                if ($registro['tabela_interior'] == '')
                {
                    $campoInterior = '<span style="color:red; background-color:yellow;" id="interior' . $comecaid . '">Prazo: ' . $registro['prazo_entrega_interior'] . ' Preços: ' . $registro['tabela_interior'] .'</span>';
                } else {
                    $campoInterior = '<span  id="interior' . $comecaid . '">Prazo: ' . $registro['prazo_entrega_interior'] . ' Preços: ' . $registro['tabela_interior'] .'</span>';
                }
                $campos2.='<p><a href="javascript:void(0);" onclick="javascript:ldcorreios_gera_uma_tabela_offline(' . $as['id'] .',' . $comecaid .  ', \'capital\'' .  ')">GERAR(Capital) ' . $as['servico'] . '-> ' . $comecaid . '</a>' . $campoCapital . '</p>';
                $campos2.='<p><a href="javascript:void(0);" onclick="javascript:ldcorreios_gera_uma_tabela_offline(' . $as['id'] .',' . $comecaid .  ', \'cidade\'' .  ')">GERAR(Cidades) ' . $as['servico'] . '-> ' . $comecaid . '</a>' . $campoCidade . '</span></p>';
                $campos2.='<p><a href="javascript:void(0);" onclick="javascript:ldcorreios_gera_uma_tabela_offline(' . $as['id'] .',' . $comecaid .  ', \'interior\'' .  ')">GERAR(Interior)' . $as['servico'] . '-> ' . $comecaid . '</a>' . $campoInterior .'</p>';
            }
            $comecaid = $primeiro;
            $primeiro = '';
            $campos.='<p><a href="#" onclick="javascript:ldcorreios_gera_dados_offline(' . $as['id'] .',' . $comecaid .  ', \'capital\',' . $comecaid .  ')">GERAR ' . $as['servico'] .'</A></p>';
        }
        $fields_form = array(
           $this->separador('Consulta de Preços Offline'),
           $this->paragrafo('Para tornar mais rápida a consulta de fretes, este módulo permite que você armazene localmente os dados de preços e prazos do sistema dos Correios. Dessa forma, caso o sistema dos Correios fique fora do ar, seus clientes poderão continuar comprando normalmente no seu site. Recomendamos que você atualize estes dados sempre que houver algum anúncio de mudança de tarifas da parte dos correios.'),
           $this->paragrafo('Lembrando que a geração para cada serviço pode demorar facilmente cerca de 1 hora, pois o processo depende da velocidade e estabilidade do web-service do Correios.'),
           $this->paragrafo('Abaixo vem um link para cada modalidade, ele tentará montar toda a tabela off-line para a modalidade selecionada, o processo demora um pouco, e as vezes pode parecer travado, aguarde com paciência, as vezes leva quase 10 min para ter uma alteração na porcentagem, este processo depende de seu servidor, sua instalação, e web-service dos correios.'),
           
           //$this->html('<a href="#" onclick="javascript:ldcorreios_gera_dados_offline(2)">GERAR PAC</A>'),
           $this->html($campos),
           $this->html('<div class="tabOffRetorno"></div>'),
           $this->paragrafo('Na sessão abaixo, você pode verificar e gerar uma tabela especifica do módulo, sempre após gerar todas as tabelas acima, verifique se faltou alguma na listagem abaixo.'),
           $this->paragrafo('Nem sempre a primeira tabela de cada modalidade é preenchida, isto é normal, ou seja, por exemplo, as 3 primeiras linhas do sedex e pac, podem ficar em branco, porém as demais devem ser geradas.'),
           $this->html($campos2),

        );
        return $this->getFormSection($fields_form, 'Dados Off-line');

    }

    public function form_debug()
    {
        $fields_form = array(
           $this->separador('Informações de Depuração'),
           $this->paragrafo('Encontre aqui informações que poderão lhe ajudar caso este módulo não esteja funcionando como deveria.'),
           $this->field_onOff('ldcorreios_debug','Habilitar modo Debug', 'Habilite esta opção em caso de problemas. Para ter alguns retornos em tela.'),
        );
        return $this->getFormSection($fields_form, 'Debug');

    }

    public function form_pgf() 
    {

        $id_servico = $this->get_id_servico('PAC-GF');

        $fields_form = array(
           $this->separador('Configurações do serviço de PAC Grandes Formatos'),
           $this->field_onOff('ldcorreios_servicos_ativo_'.$id_servico,'Ativar', 'Marque SIM para exibir esta modalidade no seu site.'),

            $this->textarea('ldcorreios_servico_desativar_faixas_'.$id_servico, 'Faixas de CEP Excluídas','',false,false,'Informe as faixas de CEP para as quais este serviço não será oferecido.', false),

            $this->separador('Dados do Contrato (opcional)'),

            $this->text ('ldcorreios_espec_codigos_'.$id_servico, 'Código de Serviço', 'input-large', false, '', true),
            $this->text ('ldcorreios_espec_codigoa_'.$id_servico, 'Código Administrativo', 'input-large', false, '', false),
            $this->text ('ldcorreios_espec_senha_'.$id_servico, 'Senha', 'input-large', false, '', false),

            $this->separador('Opções avançadas (opcional)'),

            $this->paragrafo('DIMENSÕES E PESOS'),
            $this->text ('ldcorreios_espec_compmin_'.$id_servico, 'Comprimento Mínimo', 'input-large', false, ''),
            $this->text ('ldcorreios_espec_compmax_'.$id_servico, 'Comprimento Máximo', 'input-large', false, ''),
            $this->text ('ldcorreios_espec_larguramin_'.$id_servico, 'Largura Mínima', 'input-large', false, ''),
            $this->text ('ldcorreios_espec_larguramax_'.$id_servico, 'Largura Máxima', 'input-large', false, ''),
            $this->text ('ldcorreios_espec_alturamin_'.$id_servico, 'Altura Mínima', 'input-large', false, ''),
            $this->text ('ldcorreios_espec_alturamax_'.$id_servico, 'Altura Máxima', 'input-large', false, ''),
            $this->text ('ldcorreios_espec_dimensoesmax_'.$id_servico, 'Perímetro Máximo', 'input-large', false, ''),
            $this->text ('ldcorreios_espec_pesoemax_'.$id_servico, 'Peso Máximo - Estadual', 'input-large', false, ''),
            $this->text ('ldcorreios_espec_pesonmax_'.$id_servico, 'Peso Máximo - Nacional', 'input-large', false, ''),
            $this->textarea('ldcorreios_espec_intervaloe_'.$id_servico, 'Intervalos de Pesos - Estadual','',false,false,'', false),
            $this->textarea('ldcorreios_espec_intervalon_'.$id_servico, 'Intervalos de Pesos - Nacional','',false,false,'', false),
            $this->paragrafo('VALORES PARA CÁLCULO OFFLINE'),
            $this->text ('ldcorreios_espec_cubagemi_'.$id_servico, 'Cubagem Máxima Isenta', 'input-large', false, ''),
            $this->text ('ldcorreios_espec_cubagemb_'.$id_servico, 'Cubagem para base do cálculo', 'input-large', false, ''),
            $this->text ('ldcorreios_espec_maopropria_'.$id_servico, 'Tarifa Mão Própria', 'input-large', false, ''),
            $this->text ('ldcorreios_espec_aviso_'.$id_servico, 'Tarifa Aviso de Recebimento', 'input-large', false, ''),
            $this->text ('ldcorreios_espec_valord_'.$id_servico, 'Valor Declarado (%)', 'input-large', false, ''),
            $this->text ('ldcorreios_espec_valordmax_'.$id_servico, 'Máximo valor declarado', 'input-large', false, ''),
            $this->text ('ldcorreios_espec_seguro_'.$id_servico, 'Seguro Automático', 'input-large', false, ''),

        );
        return $this->getFormSection($fields_form, 'PAC GF');
    }


    public function form_sedex12() 
    {
        $id_servico = $this->get_id_servico('SEDEX 12');

        $fields_form = array(
           $this->separador('Configurações do serviço de Sedex 12'),
           $this->field_onOff('ldcorreios_servicos_ativo_'.$id_servico,'Ativar', 'Marque SIM para exibir esta modalidade no seu site.'),

            $this->textarea('ldcorreios_servico_desativar_faixas_'.$id_servico, 'Faixas de CEP Excluídas','',false,false,'Informe as faixas de CEP para as quais este serviço não será oferecido.', false),

            $this->separador('Dados do Contrato (opcional)'),

            $this->text ('ldcorreios_espec_codigos_'.$id_servico, 'Código de Serviço', 'input-large', false, '', true),
            $this->text ('ldcorreios_espec_codigoa_'.$id_servico, 'Código Administrativo', 'input-large', false, '', false),
            $this->text ('ldcorreios_espec_senha_'.$id_servico, 'Senha', 'input-large', false, '', false),

            $this->separador('Opções avançadas (opcional)'),

            $this->paragrafo('DIMENSÕES E PESOS'),
            $this->text ('ldcorreios_espec_compmin_'.$id_servico, 'Comprimento Mínimo', 'input-large', false, ''),
            $this->text ('ldcorreios_espec_compmax_'.$id_servico, 'Comprimento Máximo', 'input-large', false, ''),
            $this->text ('ldcorreios_espec_larguramin_'.$id_servico, 'Largura Mínima', 'input-large', false, ''),
            $this->text ('ldcorreios_espec_larguramax_'.$id_servico, 'Largura Máxima', 'input-large', false, ''),
            $this->text ('ldcorreios_espec_alturamin_'.$id_servico, 'Altura Mínima', 'input-large', false, ''),
            $this->text ('ldcorreios_espec_alturamax_'.$id_servico, 'Altura Máxima', 'input-large', false, ''),
            $this->text ('ldcorreios_espec_dimensoesmax_'.$id_servico, 'Perímetro Máximo', 'input-large', false, ''),
            $this->text ('ldcorreios_espec_pesoemax_'.$id_servico, 'Peso Máximo - Estadual', 'input-large', false, ''),
            $this->text ('ldcorreios_espec_pesonmax_'.$id_servico, 'Peso Máximo - Nacional', 'input-large', false, ''),
            $this->textarea('ldcorreios_espec_intervaloe_'.$id_servico, 'Intervalos de Pesos - Estadual','',false,false,'', false),
            $this->textarea('ldcorreios_espec_intervalon_'.$id_servico, 'Intervalos de Pesos - Nacional','',false,false,'', false),
            $this->paragrafo('VALORES PARA CÁLCULO OFFLINE'),
            $this->text ('ldcorreios_espec_cubagemi_'.$id_servico, 'Cubagem Máxima Isenta', 'input-large', false, ''),
            $this->text ('ldcorreios_espec_cubagemb_'.$id_servico, 'Cubagem para base do cálculo', 'input-large', false, ''),
            $this->text ('ldcorreios_espec_maopropria_'.$id_servico, 'Tarifa Mão Própria', 'input-large', false, ''),
            $this->text ('ldcorreios_espec_aviso_'.$id_servico, 'Tarifa Aviso de Recebimento', 'input-large', false, ''),
            $this->text ('ldcorreios_espec_valord_'.$id_servico, 'Valor Declarado (%)', 'input-large', false, ''),
            $this->text ('ldcorreios_espec_valordmax_'.$id_servico, 'Máximo valor declarado', 'input-large', false, ''),
            $this->text ('ldcorreios_espec_seguro_'.$id_servico, 'Seguro Automático', 'input-large', false, ''),

        );
        return $this->getFormSection($fields_form, 'Sedex 12');
    }


    public function form_sedexhoje() 
    {
        $id_servico = $this->get_id_servico('SEDEX HOJE');

        $fields_form = array(
           $this->separador('Configurações do serviço de Sedex Hoje'),
           $this->field_onOff('ldcorreios_servicos_ativo_'.$id_servico,'Ativar', 'Marque SIM para exibir esta modalidade no seu site.'),

            $this->textarea('ldcorreios_servico_desativar_faixas_'.$id_servico, 'Faixas de CEP Excluídas','',false,false,'Informe as faixas de CEP para as quais este serviço não será oferecido.', false),

            $this->separador('Dados do Contrato (opcional)'),

            $this->text ('ldcorreios_espec_codigos_'.$id_servico, 'Código de Serviço', 'input-large', false, '', true),
            $this->text ('ldcorreios_espec_codigoa_'.$id_servico, 'Código Administrativo', 'input-large', false, '', false),
            $this->text ('ldcorreios_espec_senha_'.$id_servico, 'Senha', 'input-large', false, '', false),

            $this->separador('Opções avançadas (opcional)'),

            $this->paragrafo('DIMENSÕES E PESOS'),
            $this->text ('ldcorreios_espec_compmin_'.$id_servico, 'Comprimento Mínimo', 'input-large', false, ''),
            $this->text ('ldcorreios_espec_compmax_'.$id_servico, 'Comprimento Máximo', 'input-large', false, ''),
            $this->text ('ldcorreios_espec_larguramin_'.$id_servico, 'Largura Mínima', 'input-large', false, ''),
            $this->text ('ldcorreios_espec_larguramax_'.$id_servico, 'Largura Máxima', 'input-large', false, ''),
            $this->text ('ldcorreios_espec_alturamin_'.$id_servico, 'Altura Mínima', 'input-large', false, ''),
            $this->text ('ldcorreios_espec_alturamax_'.$id_servico, 'Altura Máxima', 'input-large', false, ''),
            $this->text ('ldcorreios_espec_dimensoesmax_'.$id_servico, 'Perímetro Máximo', 'input-large', false, ''),
            $this->text ('ldcorreios_espec_pesoemax_'.$id_servico, 'Peso Máximo - Estadual', 'input-large', false, ''),
            $this->text ('ldcorreios_espec_pesonmax_'.$id_servico, 'Peso Máximo - Nacional', 'input-large', false, ''),
            $this->textarea('ldcorreios_espec_intervaloe_'.$id_servico, 'Intervalos de Pesos - Estadual','',false,false,'', false),
            $this->textarea('ldcorreios_espec_intervalon_'.$id_servico, 'Intervalos de Pesos - Nacional','',false,false,'', false),
            $this->paragrafo('VALORES PARA CÁLCULO OFFLINE'),
            $this->text ('ldcorreios_espec_cubagemi_'.$id_servico, 'Cubagem Máxima Isenta', 'input-large', false, ''),
            $this->text ('ldcorreios_espec_cubagemb_'.$id_servico, 'Cubagem para base do cálculo', 'input-large', false, ''),
            $this->text ('ldcorreios_espec_maopropria_'.$id_servico, 'Tarifa Mão Própria', 'input-large', false, ''),
            $this->text ('ldcorreios_espec_aviso_'.$id_servico, 'Tarifa Aviso de Recebimento', 'input-large', false, ''),
            $this->text ('ldcorreios_espec_valord_'.$id_servico, 'Valor Declarado (%)', 'input-large', false, ''),
            $this->text ('ldcorreios_espec_valordmax_'.$id_servico, 'Máximo valor declarado', 'input-large', false, ''),
            $this->text ('ldcorreios_espec_seguro_'.$id_servico, 'Seguro Automático', 'input-large', false, ''),

        );
        return $this->getFormSection($fields_form, 'Sedex Hoje');

    }

    public function form_embalagens()
    {
        $embalagens = $this->get_embalagens();

        $total_embalagens = 0;
        $i = 1;
        foreach($embalagens as $embalagem)
        {
            $fields_form[] = $this->separador('Caixa #'.$i);
            $fields_form[] = $this->text ('ldcorreios_caixa_nome_'.$i, 'Nome', 'input-large', false, '');
            $fields_form[] = $this->text ('ldcorreios_caixa_largura_'.$i, 'Largura', 'input-large', false, '');
            $fields_form[] = $this->text ('ldcorreios_caixa_comprimento_'.$i, 'Comprimento', 'input-large', false, '');
            $fields_form[] = $this->text ('ldcorreios_caixa_altura_'.$i, 'Altura', 'input-large', false, '');
            $fields_form[] = $this->text ('ldcorreios_caixa_peso_'.$i, 'Peso', 'input-large', false, '');
            $fields_form[] = $this->text ('ldcorreios_caixa_preco_'.$i, 'Preço de Custo', 'input-large', false, '');
            $fields_form[] =  $this->field_onOff('ldcorreios_caixa_ativo_'.$i,'Ativo', 'Marque SIM para usar essa caixa.');
            $fields_form[] =  $this->field_onOff('ldcorreios_caixa_excluir_'.$i,'Excluir', 'Marque SIM para excluir essa caixa ao salvar.');
          
            $total_embalagens=$i;
            $i++;
        }

        $fields_form[] = $this->separador('Adicionar Nova Caixa (opcional)');

        $fields_form[] = $this->separador('Nova Caixa');
            $fields_form[] = $this->text ('ldcorreios_caixa_nome_'.'nova', 'Nome', 'input-large', false, '');
            $fields_form[] = $this->text ('ldcorreios_caixa_largura_'.'nova', 'Largura', 'input-large', false, '');
            $fields_form[] = $this->text ('ldcorreios_caixa_comprimento_'.'nova', 'Comprimento', 'input-large', false, '');
            $fields_form[] = $this->text ('ldcorreios_caixa_altura_'.'nova', 'Altura', 'input-large', false, '');
            $fields_form[] = $this->text ('ldcorreios_caixa_peso_'.'nova', 'Peso', 'input-large', false, '');
            $fields_form[] = $this->text ('ldcorreios_caixa_preco_'.'nova', 'Preço de Custo', 'input-large', false, '');
            $fields_form[] =  $this->field_onOff('ldcorreios_caixa_ativo_'.'nova','Ativo', 'Marque SIM para usar essa caixa.');
            if(empty($total_embalagens))
                $total_embalagens=0;
            $fields_form[] = $this->field_hidden('ldcorreios_total_caixas', $total_embalagens); 

        return $this->getFormSection($fields_form, 'Caixas');

    }

    public function form_fretegratis()
    {
        
        $fields_form[]=$this->separador('Frete Grátis por Faixas de CEP');
        $fields_form[]= $this->paragrafo('Nesta página, você poderá informar as faixas de CEP para as quais deseja oferecer Frete Grátis. As faixas para frete grátis deverão ser informadas por intervalos de CEP. Para ter múltiplos intervalos, separe-os com uma barra. Exemplos:');
        $fields_form[]=$this->paragrafo('1 - Para ter frete grátis em pedidos de qualquer valor do cep 11111-111 até o 22222-222, escreva da seguinte forma: 11111111:22222222:0/');
        $fields_form[]=$this->paragrafo('2 - Para ter frete grátis do cep 11111-111 até o 22222-222, e também do CEP 33333-333 até o 44444-444 escreva da seguinte forma: 11111111:22222222:0/33333333:44444444:0/');
        $fields_form[]=$this->paragrafo('3 - Para ter frete grátis do cep 11111-111 até o 22222-222, para pedidos a partir de 50 reais, escreva assim: 11111111:22222222:50/');

        $faixas_gratis = $this->get_faixas_gratis();

        foreach($faixas_gratis as $fg)
        {
            $fields_form[]=$this->textarea('ldcorreios_fg_'.$fg['id_especificacao'], $fg['nome_regiao'],'',false,false,'Informe as faixas de CEP para oferecer Frete Grátis via '.$fg['nome_regiao'], false);
        }
       
        return $this->getFormSection($fields_form, 'FRETE GRÁTIS');
    }

    private function get_faixas_gratis()
    {
        $sql = 'SELECT id, nome_regiao, regiao_cep_excluido, ativo, id_especificacao FROM ld_correios_frete_gratis
                WHERE id_shop='.$this->context->shop->id;

        return Db::getInstance()->ExecuteS($sql);
    }

    public function form_sedex10() 
    {

        $id_servico = $this->get_id_servico('SEDEX 10');

        $fields_form = array(
           $this->separador('Configurações do serviço de Sedex 10'),
           $this->field_onOff('ldcorreios_servicos_ativo_'.$id_servico,'Ativar', 'Marque SIM para exibir esta modalidade no seu site.'),

            $this->textarea('ldcorreios_servico_desativar_faixas_'.$id_servico, 'Faixas de CEP Excluídas','',false,false,'Informe as faixas de CEP para as quais este serviço não será oferecido.', false),

            $this->separador('Dados do Contrato (opcional)'),

            $this->text ('ldcorreios_espec_codigos_'.$id_servico, 'Código de Serviço', 'input-large', false, '', true),
            $this->text ('ldcorreios_espec_codigoa_'.$id_servico, 'Código Administrativo', 'input-large', false, '', false),
            $this->text ('ldcorreios_espec_senha_'.$id_servico, 'Senha', 'input-large', false, '', false),

            $this->separador('Opções avançadas (opcional)'),

            $this->paragrafo('DIMENSÕES E PESOS'),
            $this->text ('ldcorreios_espec_compmin_'.$id_servico, 'Comprimento Mínimo', 'input-large', false, ''),
            $this->text ('ldcorreios_espec_compmax_'.$id_servico, 'Comprimento Máximo', 'input-large', false, ''),
            $this->text ('ldcorreios_espec_larguramin_'.$id_servico, 'Largura Mínima', 'input-large', false, ''),
            $this->text ('ldcorreios_espec_larguramax_'.$id_servico, 'Largura Máxima', 'input-large', false, ''),
            $this->text ('ldcorreios_espec_alturamin_'.$id_servico, 'Altura Mínima', 'input-large', false, ''),
            $this->text ('ldcorreios_espec_alturamax_'.$id_servico, 'Altura Máxima', 'input-large', false, ''),
            $this->text ('ldcorreios_espec_dimensoesmax_'.$id_servico, 'Perímetro Máximo', 'input-large', false, ''),
            $this->text ('ldcorreios_espec_pesoemax_'.$id_servico, 'Peso Máximo - Estadual', 'input-large', false, ''),
            $this->text ('ldcorreios_espec_pesonmax_'.$id_servico, 'Peso Máximo - Nacional', 'input-large', false, ''),
            $this->textarea('ldcorreios_espec_intervaloe_'.$id_servico, 'Intervalos de Pesos - Estadual','',false,false,'', false),
            $this->textarea('ldcorreios_espec_intervalon_'.$id_servico, 'Intervalos de Pesos - Nacional','',false,false,'', false),
            $this->paragrafo('VALORES PARA CÁLCULO OFFLINE'),
            $this->text ('ldcorreios_espec_cubagemi_'.$id_servico, 'Cubagem Máxima Isenta', 'input-large', false, ''),
            $this->text ('ldcorreios_espec_cubagemb_'.$id_servico, 'Cubagem para base do cálculo', 'input-large', false, ''),
            $this->text ('ldcorreios_espec_maopropria_'.$id_servico, 'Tarifa Mão Própria', 'input-large', false, ''),
            $this->text ('ldcorreios_espec_aviso_'.$id_servico, 'Tarifa Aviso de Recebimento', 'input-large', false, ''),
            $this->text ('ldcorreios_espec_valord_'.$id_servico, 'Valor Declarado (%)', 'input-large', false, ''),
            $this->text ('ldcorreios_espec_valordmax_'.$id_servico, 'Máximo valor declarado', 'input-large', false, ''),
            $this->text ('ldcorreios_espec_seguro_'.$id_servico, 'Seguro Automático', 'input-large', false, ''),

        );
        return $this->getFormSection($fields_form, 'Sedex 10');
    }

    private function get_id_servico($nome)
    {
        $id_especificacao = Db::getInstance()->getValue('SELECT id FROM ld_correios_especificacoes WHERE servico="'.$nome.'" AND id_shop='.$this->context->shop->id); 

        $id_servico = Db::getInstance()->getValue('SELECT id FROM ld_correios_servicos WHERE id_especificacao='.$id_especificacao.' AND id_shop='.$this->context->shop->id);

        return $id_servico;
    }


    public function form_sedex() 
    {
        $id_servico = $this->get_id_servico('SEDEX');

        $fields_form = array(
           $this->separador('Configurações do serviço de Sedex'),
           $this->field_onOff('ldcorreios_servicos_ativo_'.$id_servico,'Ativar', 'Marque SIM para exibir esta modalidade no seu site.'),

            $this->textarea('ldcorreios_servico_desativar_faixas_'.$id_servico, 'Faixas de CEP Excluídas','',false,false,'Informe as faixas de CEP para as quais este serviço não será oferecido.', false),

            $this->separador('Dados do Contrato (opcional)'),

            $this->text ('ldcorreios_espec_codigos_'.$id_servico, 'Código de Serviço', 'input-large', false, '', true),
            $this->text ('ldcorreios_espec_codigoa_'.$id_servico, 'Código Administrativo', 'input-large', false, '', false),
            $this->text ('ldcorreios_espec_senha_'.$id_servico, 'Senha', 'input-large', false, '', false),

            $this->separador('Opções avançadas (opcional)'),

            $this->paragrafo('DIMENSÕES E PESOS'),
            $this->text ('ldcorreios_espec_compmin_'.$id_servico, 'Comprimento Mínimo', 'input-large', false, ''),
            $this->text ('ldcorreios_espec_compmax_'.$id_servico, 'Comprimento Máximo', 'input-large', false, ''),
            $this->text ('ldcorreios_espec_larguramin_'.$id_servico, 'Largura Mínima', 'input-large', false, ''),
            $this->text ('ldcorreios_espec_larguramax_'.$id_servico, 'Largura Máxima', 'input-large', false, ''),
            $this->text ('ldcorreios_espec_alturamin_'.$id_servico, 'Altura Mínima', 'input-large', false, ''),
            $this->text ('ldcorreios_espec_alturamax_'.$id_servico, 'Altura Máxima', 'input-large', false, ''),
            $this->text ('ldcorreios_espec_dimensoesmax_'.$id_servico, 'Perímetro Máximo', 'input-large', false, ''),
            $this->text ('ldcorreios_espec_pesoemax_'.$id_servico, 'Peso Máximo - Estadual', 'input-large', false, ''),
            $this->text ('ldcorreios_espec_pesonmax_'.$id_servico, 'Peso Máximo - Nacional', 'input-large', false, ''),
            $this->textarea('ldcorreios_espec_intervaloe_'.$id_servico, 'Intervalos de Pesos - Estadual','',false,false,'', false),
            $this->textarea('ldcorreios_espec_intervalon_'.$id_servico, 'Intervalos de Pesos - Nacional','',false,false,'', false),
            $this->paragrafo('VALORES PARA CÁLCULO OFFLINE'),
            $this->text ('ldcorreios_espec_cubagemi_'.$id_servico, 'Cubagem Máxima Isenta', 'input-large', false, ''),
            $this->text ('ldcorreios_espec_cubagemb_'.$id_servico, 'Cubagem para base do cálculo', 'input-large', false, ''),
            $this->text ('ldcorreios_espec_maopropria_'.$id_servico, 'Tarifa Mão Própria', 'input-large', false, ''),
            $this->text ('ldcorreios_espec_aviso_'.$id_servico, 'Tarifa Aviso de Recebimento', 'input-large', false, ''),
            $this->text ('ldcorreios_espec_valord_'.$id_servico, 'Valor Declarado (%)', 'input-large', false, ''),
            $this->text ('ldcorreios_espec_valordmax_'.$id_servico, 'Máximo valor declarado', 'input-large', false, ''),
            $this->text ('ldcorreios_espec_seguro_'.$id_servico, 'Seguro Automático', 'input-large', false, ''),

        );
        return $this->getFormSection($fields_form, 'Sedex');
    }



    public function get_campos_sedex()
    {

    }

    public function getFormSection ($fields_form, $title, $icon = 'icon-cogs') {
        return array(
            'form' => array(
                'legend' => array(
                    'title' => $title,
                    'icon' => $icon
                ),
                'input' => $fields_form,
                'submit' => array(
                    'title' => $this->l('Save')
                )
            )
        );
    }

    protected function textarea ($name, $label, $class = '', $lang = false, $editor = true, $hint = '',
        $required='') {
        $field = array ();
        $field['type'] = 'textarea';
        $field['label'] = $this->l($label);
        $field['name'] = $name;
        if($class) $field['class'] = $class;
        if($lang) $field['lang'] = $lang;
        if($editor) $field['autoload_rte'] = $editor;
        if($hint) $field['hint'] = $this->l($hint);
        if($required) $field['required'] = $required;
        
        return $field;
    }
    protected function text ($name, $label, $class = '', $lang = false, $hint = '',$required='', $suffix = '') {
        $field = array ();
        $field['type'] = 'text';
        $field['label'] = $label;
        $field['name'] = $name;
        
        if($class) $field['class'] = $class;
        if($lang) $field['lang'] = $lang;
        if($hint) $field['hint'] = $this->l($hint);
        if($required) $field['required'] = $required;
        if (!empty($suffix)) $field['suffix'] = $suffix;
        
        return $field;
    }

    protected function separador($texto) 
    {
       return  array(
                    'type' => 'free',
                    'name' => 'SEPARADOR',
                    'desc' => '<H2>'.$texto.'</H2>',
                    'required' => false
                );
        
    }

    protected function html($html) 
    {
       return  array(
                    'type' => 'free',
                    'name' => 'SEPARADOR',
                    'desc' => $html,
                    'required' => false
                );
        
    }
	
    protected function paragrafo($texto) 
    {
       return  array(
                    'type' => 'free',
                    'name' => 'PARAGRAFO',
                    'desc' => '<p>'.$texto.'</p>',
                    'required' => false
                );
        
    }

    protected function field_onOff ($name, $label,$des ='') {
        return array(
            'type' => 'switch',
            'label' => $label,
            'name' => $name,
            'desc' => $des,
            'is_bool' => true,
            'required' => false,
            'values' => array(
                array(
                    'id' => $name.'_ON',
                    'value' => 1,
                    'label' => $this->l('Enabled')
                ),
                array(
                    'id' => $name.'_OFF',
                    'value' => 0,
                    'label' => $this->l('Disabled')
                )
            )
        );
    }

    protected function field_hidden($nome, $valor='')
    {
        return array(
            'type' => 'hidden',
            'value' => $valor,
            'name' => $nome
          ); 
    }
    protected function checkbox($name, $label, $options,$desc='')
    {
       return array(
                'type'    => 'checkbox',                         
                'label'   => $label,               
                'desc'    => $desc, 
                'required' => false,      
                'name'    => $name,     
                'values'  => array(
                    'query' => $options,
                    'id'    => 'id',
                    'name'  => 'name',
                ));
    }

    private function get_embalagens()
    {
        $sql = "SELECT id, descricao, comprimento, altura, largura, peso, cubagem, custo, ativo
                FROM ld_correios_embalagens
                WHERE id_shop = ".$this->context->shop->id;

        return Db::getInstance()->ExecuteS($sql);
    }

    private function recuperaServicosCorreios() {

        // Servicos dos Correios
        $sql = 'SELECT
                  ld_correios_servicos.*,
                  ld_correios_especificacoes.servico
                FROM ld_correios_servicos
                  INNER JOIN ld_correios_especificacoes
                    ON ld_correios_servicos.id_especificacao = ld_correios_especificacoes.id
                WHERE ld_correios_servicos.id_shop = '.(int)$this->context->shop->id;

        return Db::getInstance()->ExecuteS($sql);
    }

   
}
