<?php
/**
* 2013-2018 Ovidiu Cimpean
*
* Ovidiu Cimpean - Newsletter Pro © All rights reserved.
*
* DISCLAIMER
*
* Do not edit, modify or copy this file.
* If you wish to customize it, contact us at addons4prestashop@gmail.com.
*
* @author    Ovidiu Cimpean <addons4prestashop@gmail.com>
* @copyright 2013-2018 Ovidiu Cimpean
* @license   Do not edit, modify or copy this file
* @version   Release: 4
*/

class NewsletterProDbTransaction
{
	const DB_TYPE_MYSQL = 'MySQL';
	const DB_TYPE_PDO = 'DbPDO';
	const DB_TYPE_MYSQLI = 'DbMySQLi';

	const FETCH_ASSOC = 1;

	private $type;

	public $db;

	public $conn;


	/**
	 * The transaction will fetch only one record
	 */
	public function __construct()
	{
		$this->type = Db::getClass();
		$this->db = Db::getInstance();
		$this->conn = $this->db->connect();
	}

	public static function newInstance()
	{
		return new self();
	}

	public function begin()
	{
		if ($this->type == self::DB_TYPE_PDO)
		{
			$this->conn->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
			$this->conn->beginTransaction();
		}
		else if ($this->type == self::DB_TYPE_MYSQLI)
		{
			$this->conn->begin_transaction();
		}
		else if ($this->type == self::DB_TYPE_MYSQL)
		{
			mysql_query('START TRANSACTION', $this->conn);
			mysql_query('BEGIN', $this->conn);
		}
		else
			$this->throwDatabaseTypeError();
	}

	public function exec($query)
	{
		if ($this->type == self::DB_TYPE_PDO)
		{
			$this->conn->exec($query);
		}
		else if ($this->type == self::DB_TYPE_MYSQLI)
		{
			$this->conn->query($query);
		}
		else if ($this->type == self::DB_TYPE_MYSQL)
		{
			mysql_query($query, $this->conn);
		}
		else
			$this->throwDatabaseTypeError();
	}

	public function query($query, $fetch = self::FETCH_ASSOC)
	{
		if ($this->type == self::DB_TYPE_PDO)
		{
			$q = $this->conn->query($query);

			$f = PDO::FETCH_ASSOC;
			switch ($fetch) {
				case self::FETCH_ASSOC:
				default:
					$f = PDO::FETCH_ASSOC;
					break;
			}

			return $q->fetch($f);

		}
		else if ($this->type == self::DB_TYPE_MYSQLI)
		{
			$q = $this->conn->query($query);

			$f = 'fetch_assoc';

			switch ($fetch) {
				case self::FETCH_ASSOC:
				default:
					$f = 'fetch_assoc';
					break;
			}

			return call_user_func(array($q, $f));
		}
		else if ($this->type == self::DB_TYPE_MYSQL)
		{
			$q = mysql_query($query);

			$f = 'mysql_fetch_assoc';

			switch ($fetch) {
				case self::FETCH_ASSOC:
				default:
					$f = 'mysql_fetch_assoc';
					break;
			}
			return call_user_func($f, $q);
		}
		else
			$this->throwDatabaseTypeError();
	}

	public function commit()
	{
		if ($this->type == self::DB_TYPE_PDO || $this->type == self::DB_TYPE_MYSQLI)
		{
			$this->conn->commit();
		}
		else if ($this->type == self::DB_TYPE_MYSQL)
		{
			mysql_query('COMMIT', $this->conn);
		}
		else
			$this->throwDatabaseTypeError();
	}

	public function rollback()
	{
		if ($this->type == self::DB_TYPE_PDO || $this->type == self::DB_TYPE_MYSQLI)
		{
			$this->conn->rollback();
		}
		else if ($this->type == self::DB_TYPE_MYSQL)
		{
			mysql_query('ROLLBACK', $this->conn);
		}
		else
			$this->throwDatabaseTypeError();
	}

	private function throwDatabaseTypeError()
	{
		throw new Exception(sprintf('Invalid database type "%s".'), $this->type);
		
	}
}
