<?php
/**
* 2013-2018 Ovidiu Cimpean
*
* Ovidiu Cimpean - Newsletter Pro © All rights reserved.
*
* DISCLAIMER
*
* Do not edit, modify or copy this file.
* If you wish to customize it, contact us at addons4prestashop@gmail.com.
*
* @author    Ovidiu Cimpean <addons4prestashop@gmail.com>
* @copyright 2013-2018 Ovidiu Cimpean
* @license   Do not edit, modify or copy this file
* @version   Release: 4
*/

class NewsletterProRequest
{
    const TYPE_POST = 1;

    const TYPE_GET = 2;

    private $data_get = array();

    private $data_post = array();

    public function __construct()
    {
        $this->data_get = array();
        $this->data_post = array();

        foreach ($_GET as $key => $value) {
            $this->data_get[$key] = $value;
        }

        foreach ($_POST as $key => $value) {
            $this->data_post[$key] = $value;
        }
    }

    public static function newInstance()
    {
        return new self();
    }

    public function set($key, $value, $set_type = null)
    {
        $was_set = false;

        if (isset($set_type)) {
            if ($set_type == self::TYPE_GET) {
                $this->data_get[$key] = $value;    
            } else {
                $this->data_post[$key] = $value; 
            }

            return $this;
        } else {
            if (array_key_exists($key, $this->data_get)) {
                $this->data_get[$key] = $value;
                $was_set = true;
            }
    
            if (array_key_exists($key, $this->data_post)) {
                $this->data_post[$key] = $value;
                $was_set = true;
            }

            if (!$was_set) {
                $this->data_post[$key] = $value;
            }
        }


        return $this;
    }

    public function setPost($key, $value)
    {
        $this->data_post[$key] = $value;
        return $this;
    }

    public function setGet($key, $value)
    {
        $this->data_get[$key] = $value;
        return $this;
    }

    public function get($key, $defaultValue = null)
    {
        if (array_key_exists($key, $this->data_get)) {
            return $this->data_get[$key];
        }

        if (array_key_exists($key, $this->data_post)) {
            return $this->data_post[$key];
        }

        return $defaultValue;
    }

    public function getPrefix($key, $defaultValue = null)
    {
        return $this->get(_NEWSLETTER_PREFIX_ . $key, $defaultValue);
    }

    public function dataGet()
    {
        return $this->data_get;
    }

    public function dataPost()
    {
        return $this->data_post;
    }

    public function has($key)
    {
        if (array_key_exists($key, $this->data_get)) {
            return true;
        } else if (array_key_exists($key, $this->data_post)) {
            return true;
        }
        return false;
    }

    public function hasPrefix($key)
    {
        return $this->has(_NEWSLETTER_PREFIX_ . $key);
    }

    public function validate(&$errors = array(), &$form_errors = array(), $fields = array())
    {
        $data = $this->grep(array_keys($fields));
        $validate = NewsletterProValidate::newInstance()->set($data);

        $success = $validate->success($errors, $form_errors, $fields);

        $validate_data = $validate->get();

        if (is_array($validate_data) && !empty($validate_data)) {
            foreach ($validate_data as $filed_name => $filed_value) {
                if (array_key_exists($filed_name, $this->data_post)) {
                    $this->data_post[$filed_name] = $filed_value;
                }

                if (array_key_exists($filed_name, $this->data_get)) {
                    $this->data_get[$filed_name] = $filed_value;
                }
            }
        }

        return $success;
    }

    public function data($type = null, $grep_fields = array())
    {
        $data = array();
        $data_grep = array();

        if (!isset($type)) {
            $data = array_merge($this->data_get, $this->data_post);
        } else if ($type == self::TYPE_POST) {
            $data = $this->data_post;
        } else if ($type == self::TYPE_GET) {
            $data = $this->data_get;
        }

        if (empty($grep_fields)) {
            return $data;
        }

        foreach ($grep_fields as $filed_name) {
            if (array_key_exists($filed_name, $data)) {
                $data_grep[$filed_name] = $data[$filed_name];
            }
        }

        return $data_grep;
    }

    public function grep($fields = array())
    {
        $data = array();

        foreach ($fields as $filed_name) {
            if (array_key_exists($filed_name, $this->data_get)) {
                $data[$filed_name] = $this->data_get[$filed_name];
            }

            if (array_key_exists($filed_name, $this->data_post)) {
                $data[$filed_name] = $this->data_post[$filed_name];
            }
        }

        return $data;
    }
}
