<?php
/**
* 2019 PSBlog
*
* NOTICE OF LICENSE
*
* READ ATTACHED LICENSE.TXT
*
*  @author    PSBlog
*  @copyright 2019 PSBlog
*  @license   LICENSE.TXT
*/

class PrestarcardsAjxpetitionsModuleFrontController extends ModuleFrontController
{
    public function displayAjaxThemesnippets()
    {
        // Token first
        if (Tools::getValue('security') !== Configuration::get('PSB_RICHCARDS_SECUREKEY')) {
            die();
        }
            
        include(dirname(__FILE__).'/../../classes/ThemeFixer.php');
        $fixer = new ThemeFixer();
        $ficheros = $fixer->getFilesFromTheme();
        die(json_encode($ficheros));
    }

    public function displayAjaxModulesnippets()
    {
        // Token first
        if (Tools::getValue('security') !== Configuration::get('PSB_RICHCARDS_SECUREKEY')) {
            die();
        }
            
        include(dirname(__FILE__).'/../../classes/ThemeFixer.php');
        $fixer = new ThemeFixer();
        $ficheros = $fixer->getFilesFromModules();
        die(json_encode($ficheros));
    }

    /*
     * Returns a JSON with theme and module files with snippets
     */
    public function displayAjaxAllsnippets()
    {
        // Token first
        if (Tools::getValue('security') !== Configuration::get('PSB_RICHCARDS_SECUREKEY')) {
            die();
        }
            
        include(dirname(__FILE__).'/../../classes/ThemeFixer.php');
        $fixer = new ThemeFixer();
        $ficheros_tema = $fixer->getFilesFromTheme();
        $ficheros_modulo = $fixer->getFilesFromModules();
        $all_files = array(
            'theme' => $ficheros_tema,
            'modules' => $ficheros_modulo
        );
        
        die(json_encode($all_files));
    }

    /*
     * Returns a JSON with theme and module backup files
     */
    public function displayAjaxListbackup()
    {
        // Token first
        if (Tools::getValue('security') !== Configuration::get('PSB_RICHCARDS_SECUREKEY')) {
            die();
        }
            
        include(dirname(__FILE__).'/../../classes/ThemeFixer.php');
        $fixer = new ThemeFixer();
        $ficheros_tema_backup = $fixer->getFilesFromTheme(true);
        $ficheros_modulo_backup = $fixer->getFilesFromModules(true);
        //$ficheros = array_merge($ficheros_modulo_backup, $ficheros_tema_backup);
        //$fixer->removeBackups($ficheros);
        //die();
        $all_files = array(
            'theme' => $ficheros_tema_backup,
            'modules' => $ficheros_modulo_backup
        );
        
        die(json_encode($all_files));
    }

    /*
     * Creates a backup of the current affected files for THEME
     */
    public function displayAjaxBackupsnippets()
    {
        // Token first
        if (Tools::getValue('security') !== Configuration::get('PSB_RICHCARDS_SECUREKEY')) {
            die();
        }
            
        include(dirname(__FILE__).'/../../classes/ThemeFixer.php');
        $fixer = new ThemeFixer();
        $ficheros_tema = $fixer->getFilesFromTheme();
        $ficheros_modulo = $fixer->getFilesFromModules();
        $ficheros = array_merge($ficheros_tema, $ficheros_modulo);
        $fixer->backupOrRestoreFiles($ficheros);
        
        die(json_encode($ficheros));
    }
    
    /*
     * Restores a backup of the current affected files for THEME
     */
    public function displayAjaxRestoreBackup()
    {
        // Token first
        if (Tools::getValue('security') !== Configuration::get('PSB_RICHCARDS_SECUREKEY')) {
            die();
        }
            
        include(dirname(__FILE__).'/../../classes/ThemeFixer.php');
        $fixer = new ThemeFixer();
        $ficheros_tema = $fixer->getFilesFromTheme(true);
        $ficheros_modulo = $fixer->getFilesFromModules(true);

        $ficheros = array_merge($ficheros_tema, $ficheros_modulo);
        $fixer->backupOrRestoreFiles($ficheros, true);
        
        die(json_encode($ficheros));
    }

    /*
     * Removes the snippets for THEME
     */
    public function displayAjaxCleansnippets()
    {
        // Token first
        if (Tools::getValue('security') !== Configuration::get('PSB_RICHCARDS_SECUREKEY')) {
            die();
        }
        
        // Clean also modules?
        $cleanmodules = (bool)Tools::getValue('removemodules');
            
        include(dirname(__FILE__).'/../../classes/ThemeFixer.php');
        $fixer = new ThemeFixer();
        $ficheros = $fixer->getFilesFromTheme();
        $ficheros_modulo = array();
        
        if ($cleanmodules) {
            $ficheros_modulo = $fixer->getFilesFromModules();
            $ficheros = array_merge($ficheros, $ficheros_modulo);
        }
        
        $fixer->removeSnippets($ficheros);
        
        die(json_encode($ficheros));
    }
}
