<?php

namespace Spatie\Regex;

use Exception;

class RegexFailed extends Exception
{
    public static function match($pattern, $subject, $message)
    {
        $subject = static::trimString($subject);

        return new static("Error matching pattern `{$pattern}` with subject `{$subject}`. {$message}");
    }

    public static function replace($pattern, $subject, $message)
    {
        $subject = static::trimString($subject);

        return new static("Error replacing pattern `{$pattern}` in subject `{$subject}`. {$message}");
    }

    public static function groupDoesntExist($pattern, $subject, $group)
    {
        return new static("Pattern `{$pattern}` with subject `{$subject}` didn't capture a group named {$group}");
    }

    protected static function trimString($string)
    {
        if (strlen($string) < 40) {
            return $string;
        }

        return substr($string, 0, 40).'...';
    }
}
