<?php
/**
* 2007-2020 PrestaShop
*
* NOTICE OF LICENSE
*
* This source file is subject to the Academic Free License (AFL 3.0)
* that is bundled with this package in the file LICENSE.txt.
* It is also available through the world-wide-web at this URL:
* http://opensource.org/licenses/afl-3.0.php
* If you did not receive a copy of the license and are unable to
* obtain it through the world-wide-web, please send an email
* to license@prestashop.com so we can send you a copy immediately.
*
* DISCLAIMER
*
* Do not edit or add to this file if you wish to upgrade PrestaShop to newer
* versions in the future. If you wish to customize PrestaShop for your
* needs please refer to http://www.prestashop.com for more information.
*
*  @author PrestaShop SA <contact@prestashop.com>
*  @copyright  2007-2020 PrestaShop SA
*  @license    http://opensource.org/licenses/afl-3.0.php  Academic Free License (AFL 3.0)
*  International Registered Trademark & Property of PrestaShop SA
*/

class TvcmsSearchListModuleFrontController extends ModuleFrontController
{
    public function __construct()
    {
        parent::__construct();
        $this->context = Context::getContext();
        include_once($this->module->getLocalPath().'tvcmsproductcompare.php');
    }
    /**
     * @see FrontController::initContent()
     */
    public function initContent()
    {
        parent::initContent();
        $tvcms_obj = new TvcmsProductCompare();
        $prod = $tvcms_obj->getAllCompareProduct();

        $this->context->smarty->assign('prod_1', $prod['prod_1']);
        $this->context->smarty->assign('prod_2', $prod['prod_2']);
        $this->context->smarty->assign('prod_3', $prod['prod_3']);
        $this->context->smarty->assign('prod_4', $prod['prod_4']);
        $this->context->smarty->assign('id_lang', $prod['id_lang']);
        $this->context->smarty->assign('id_currency', $prod['id_currency']);
        $this->context->smarty->assign('all_feature', $prod['all_feature']);

        $this->setTemplate('module:tvcmsproductcompare/views/templates/front/tvcmsproduct_compare.tpl');
    }
}
